<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Insights\V1\Call;

use Twilio\Options;
use Twilio\Values;

abstract class CallSummaryOptions {
    /**
     * @param string $processingState The processing_state
     * @return FetchCallSummaryOptions Options builder
     */
    public static function fetch(string $processingState = Values::NONE): FetchCallSummaryOptions {
        return new FetchCallSummaryOptions($processingState);
    }
}

class FetchCallSummaryOptions extends Options {
    /**
     * @param string $processingState The processing_state
     */
    public function __construct(string $processingState = Values::NONE) {
        $this->options['processingState'] = $processingState;
    }

    /**
     * The processing_state
     *
     * @param string $processingState The processing_state
     * @return $this Fluent Builder
     */
    public function setProcessingState(string $processingState): self {
        $this->options['processingState'] = $processingState;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Insights.V1.FetchCallSummaryOptions ' . $options . ']';
    }
}