<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Voice\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class SourceIpMappingContext extends InstanceContext {
    /**
     * Initialize the SourceIpMappingContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The unique string that identifies the resource
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];

        $this->uri = '/SourceIpMappings/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the SourceIpMappingInstance
     *
     * @return SourceIpMappingInstance Fetched SourceIpMappingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): SourceIpMappingInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new SourceIpMappingInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Update the SourceIpMappingInstance
     *
     * @param string $sipDomainSid The unique string that identifies a SIP Domain
     * @return SourceIpMappingInstance Updated SourceIpMappingInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $sipDomainSid): SourceIpMappingInstance {
        $data = Values::of(['SipDomainSid' => $sipDomainSid, ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new SourceIpMappingInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Delete the SourceIpMappingInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Voice.V1.SourceIpMappingContext ' . \implode(' ', $context) . ']';
    }
}