<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Options;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

class DeactivationsContext extends InstanceContext {
    /**
     * Initialize the DeactivationsContext
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/Deactivations';
    }

    /**
     * Fetch the DeactivationsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return DeactivationsInstance Fetched DeactivationsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): DeactivationsInstance {
        $options = new Values($options);

        $params = Values::of(['Date' => Serialize::iso8601Date($options['date']), ]);

        $payload = $this->version->fetch('GET', $this->uri, $params);

        return new DeactivationsInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Messaging.V1.DeactivationsContext ' . \implode(' ', $context) . ']';
    }
}