<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\FlexApi\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property string $accountSid
 * @property string $assessmentId
 * @property array $comment
 * @property string $offset
 * @property bool $report
 * @property string $weight
 * @property string $agentId
 * @property string $segmentId
 * @property string $userName
 * @property string $userEmail
 * @property string $timestamp
 * @property string $url
 */
class InsightsAssessmentsCommentInstance extends InstanceResource {
    /**
     * Initialize the InsightsAssessmentsCommentInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     */
    public function __construct(Version $version, array $payload) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'assessmentId' => Values::array_get($payload, 'assessment_id'),
            'comment' => Values::array_get($payload, 'comment'),
            'offset' => Values::array_get($payload, 'offset'),
            'report' => Values::array_get($payload, 'report'),
            'weight' => Values::array_get($payload, 'weight'),
            'agentId' => Values::array_get($payload, 'agent_id'),
            'segmentId' => Values::array_get($payload, 'segment_id'),
            'userName' => Values::array_get($payload, 'user_name'),
            'userEmail' => Values::array_get($payload, 'user_email'),
            'timestamp' => Values::array_get($payload, 'timestamp'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = [];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.FlexApi.V1.InsightsAssessmentsCommentInstance]';
    }
}