<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class VulnerabilityOccurrence extends \Google\Collection
{
  protected $collection_key = 'relatedUrls';
  /**
   * @var float
   */
  public $cvssScore;
  protected $cvssV2Type = CVSS::class;
  protected $cvssV2DataType = '';
  /**
   * @var string
   */
  public $cvssVersion;
  protected $cvssv3Type = CVSS::class;
  protected $cvssv3DataType = '';
  /**
   * @var string
   */
  public $effectiveSeverity;
  /**
   * @var string
   */
  public $extraDetails;
  /**
   * @var bool
   */
  public $fixAvailable;
  /**
   * @var string
   */
  public $longDescription;
  protected $packageIssueType = PackageIssue::class;
  protected $packageIssueDataType = 'array';
  protected $relatedUrlsType = RelatedUrl::class;
  protected $relatedUrlsDataType = 'array';
  /**
   * @var string
   */
  public $severity;
  /**
   * @var string
   */
  public $shortDescription;
  /**
   * @var string
   */
  public $type;
  protected $vexAssessmentType = VexAssessment::class;
  protected $vexAssessmentDataType = '';

  /**
   * @param float
   */
  public function setCvssScore($cvssScore)
  {
    $this->cvssScore = $cvssScore;
  }
  /**
   * @return float
   */
  public function getCvssScore()
  {
    return $this->cvssScore;
  }
  /**
   * @param CVSS
   */
  public function setCvssV2(CVSS $cvssV2)
  {
    $this->cvssV2 = $cvssV2;
  }
  /**
   * @return CVSS
   */
  public function getCvssV2()
  {
    return $this->cvssV2;
  }
  /**
   * @param string
   */
  public function setCvssVersion($cvssVersion)
  {
    $this->cvssVersion = $cvssVersion;
  }
  /**
   * @return string
   */
  public function getCvssVersion()
  {
    return $this->cvssVersion;
  }
  /**
   * @param CVSS
   */
  public function setCvssv3(CVSS $cvssv3)
  {
    $this->cvssv3 = $cvssv3;
  }
  /**
   * @return CVSS
   */
  public function getCvssv3()
  {
    return $this->cvssv3;
  }
  /**
   * @param string
   */
  public function setEffectiveSeverity($effectiveSeverity)
  {
    $this->effectiveSeverity = $effectiveSeverity;
  }
  /**
   * @return string
   */
  public function getEffectiveSeverity()
  {
    return $this->effectiveSeverity;
  }
  /**
   * @param string
   */
  public function setExtraDetails($extraDetails)
  {
    $this->extraDetails = $extraDetails;
  }
  /**
   * @return string
   */
  public function getExtraDetails()
  {
    return $this->extraDetails;
  }
  /**
   * @param bool
   */
  public function setFixAvailable($fixAvailable)
  {
    $this->fixAvailable = $fixAvailable;
  }
  /**
   * @return bool
   */
  public function getFixAvailable()
  {
    return $this->fixAvailable;
  }
  /**
   * @param string
   */
  public function setLongDescription($longDescription)
  {
    $this->longDescription = $longDescription;
  }
  /**
   * @return string
   */
  public function getLongDescription()
  {
    return $this->longDescription;
  }
  /**
   * @param PackageIssue[]
   */
  public function setPackageIssue($packageIssue)
  {
    $this->packageIssue = $packageIssue;
  }
  /**
   * @return PackageIssue[]
   */
  public function getPackageIssue()
  {
    return $this->packageIssue;
  }
  /**
   * @param RelatedUrl[]
   */
  public function setRelatedUrls($relatedUrls)
  {
    $this->relatedUrls = $relatedUrls;
  }
  /**
   * @return RelatedUrl[]
   */
  public function getRelatedUrls()
  {
    return $this->relatedUrls;
  }
  /**
   * @param string
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return string
   */
  public function getSeverity()
  {
    return $this->severity;
  }
  /**
   * @param string
   */
  public function setShortDescription($shortDescription)
  {
    $this->shortDescription = $shortDescription;
  }
  /**
   * @return string
   */
  public function getShortDescription()
  {
    return $this->shortDescription;
  }
  /**
   * @param string
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * @param VexAssessment
   */
  public function setVexAssessment(VexAssessment $vexAssessment)
  {
    $this->vexAssessment = $vexAssessment;
  }
  /**
   * @return VexAssessment
   */
  public function getVexAssessment()
  {
    return $this->vexAssessment;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VulnerabilityOccurrence::class, 'Google_Service_OnDemandScanning_VulnerabilityOccurrence');
